#! /bin/sh
# This script integrates FabuleTech library to Omnissa Horizon Client
#

set -e

LIB_PATH="/opt/ftplugins/lib/ftblastbr.so"
CLIENT_DIR="/usr/lib/omnissa/rdpvcbridge"
CLIENT_CONFIG_FILE="freerdp_plugins.conf"
LIB_NAME="ftblastbr.so"

usage () {
echo "\
Usage: $(basename $0) -i|-u,
where:
        -i      - Install Omnissa Blast support
        -u      - Uninstall Omnissa Blast support
        -h      - Show help"
}

enable_plugin () {
sed \
'$ a\
ftblastbr=enabled' \
"$1" > "$1".tmp
cat "$1".tmp > "$1"
rm -f "$1".tmp
}

disable_plugin () {
sed \
-e '/ftblastbr/ d' \
"$1" > "$1".tmp
cat "$1".tmp > "$1"
rm -f "$1".tmp
}

case "$1" in
"-i")
	if [ -d "$CLIENT_DIR" ]
	then
		rm -f "$CLIENT_DIR/$LIB_NAME"
		disable_plugin "$CLIENT_DIR/$CLIENT_CONFIG_FILE"
		ln -s "$LIB_PATH" "$CLIENT_DIR/$LIB_NAME"
		enable_plugin "$CLIENT_DIR/$CLIENT_CONFIG_FILE"
		echo "Installed for Omnissa Horizon Client"
	else
		echo "Directory $CLIENT_DIR does not exists, probably Omnissa Horizon Client is not installed"
		exit 0
	fi
	;;
"-u")
	if [ -d "$CLIENT_DIR" ]
	then
		rm -f "$CLIENT_DIR/$LIB_NAME"
		disable_plugin "$CLIENT_DIR/$CLIENT_CONFIG_FILE"
		echo "Uninstalled for Omnissa Horizon Client"
	else
		echo "Directory $CLIENT_DIR does not exists, probably Omnissa Horizon Client is not installed"
		exit 0
	fi
	;;
"-h")
	usage
	;;
*)
	usage
	;;
esac

