#! /bin/sh
# This script integrates FabuleTech library to Teradici Agent, Teradici Client
# and VMware Horizon Client

set -e

LIB_PATH="/opt/ftplugins/lib/ftpcoipbr.so"

LIB_NAME="libvchan-plugin-ftpcoipbr.so"

CLIENT_DIR="/usr/lib/pcoip"
CLIENT_PLUGINS_DIR="/usr/lib/pcoip/vchan_plugins"
CLIENT_PLUGINS_DIR_OPT="/opt/pcoip-client/lib/vchan_plugins"
AGENT_PLUGINS_DIR="/usr/lib/pcoip-agent/vchan-plugins"

ARCH="unknown"

usage () {
echo "\
Usage: $(basename $0) -i|-u,
where:
        -i      - Install PCoIP support
        -u      - Uninstall PCoIP support
        -h      - Show help"
}

gnu_suffixes () {
	p1="gnu"
	p2="gnueabi"
	p3="gnueabihf"
	echo $p1 $p2 $p3
}

arch_dirs () {
	if [ "x$ARCH" != "xunknown" ]
	then
		suffixes=$(gnu_suffixes)
		for suf in $suffixes
		do
			p1="/usr/lib/$ARCH-linux-$suf"
			p2="/usr/local/lib/$ARCH-linux-$suf"
			p3="/usr/lib64/$ARCH-linux-$suf"
			p4="/usr/local/lib64/$ARCH-linux-$suf"
			echo $p1 $p2 $p3 $p4
		done
	fi
}

link_lib () {
	if [ -d "$AGENT_PLUGINS_DIR" ]
	then
		ln -s $LIB_PATH "$AGENT_PLUGINS_DIR/$LIB_NAME"
		if [ $? = 0 ]
		then
			echo "linked: $AGENT_PLUGINS_DIR/$LIB_NAME"
		else
			echo "ERROR: unable to cteate link: $AGENT_PLUGINS_DIR/$LIB_NAME"
		fi
	fi
	
	if [ ! -d  $CLIENT_DIR  ]
	then
		mkdir $CLIENT_DIR
		if [ $? != 0 ]
		then
			echo "ERROR: unable to cteate directory: $CLIENT_DIR"
		fi
	fi
	if [ -d  $CLIENT_DIR -a ! -d $CLIENT_PLUGINS_DIR  ]
	then
		mkdir $CLIENT_PLUGINS_DIR
		if [ $? != 0 ]
		then
			echo "ERROR: unable to cteate directory: $CLIENT_PLUGINS_DIR"
		fi
	fi
	if [ -d $CLIENT_PLUGINS_DIR  ]
	then
		ln -s $LIB_PATH "$CLIENT_PLUGINS_DIR/$LIB_NAME"
		if [ $? = 0 ]
		then
			echo "linked: $CLIENT_PLUGINS_DIR/$LIB_NAME"
		else
			echo "ERROR: unable to cteate link: $CLIENT_PLUGINS_DIR/$LIB_NAME"
		fi
	fi
	
	if [ -d $CLIENT_PLUGINS_DIR_OPT  ]
	then
		ln -s $LIB_PATH "$CLIENT_PLUGINS_DIR_OPT/$LIB_NAME"
		if [ $? = 0 ]
		then
			echo "linked: $CLIENT_PLUGINS_DIR_OPT/$LIB_NAME"
		else
			echo "ERROR: unable to cteate link: $CLIENT_PLUGINS_DIR_OPT/$LIB_NAME"
		fi
	fi
	
	dirs=$(arch_dirs)
	for dir in $dirs
	do
		cl_dir=$dir/pcoip-client
		if [ -d  $dir -a ! -d  $cl_dir  ]
		then
			mkdir $cl_dir
			if [ $? != 0 ]
			then
				echo "ERROR: unable to cteate directory: $cl_dir"
			fi
		fi
		
		pl_dir=$cl_dir/vchan_plugins
		if [ -d  $cl_dir -a ! -d $pl_dir  ]
		then
			mkdir $pl_dir
			if [ $? != 0 ]
			then
				echo "ERROR: unable to cteate directory: $pl_dir"
			fi
		fi
		if [ -d $pl_dir  ]
		then
			ln -s $LIB_PATH $pl_dir/$LIB_NAME
			if [ $? = 0 ]
			then
				echo "linked: $pl_dir/$LIB_NAME"
			else
				echo "ERROR: unable to cteate link: $pl_dir/$LIB_NAME"				
			fi
		fi
		
		ag_dir=$dir/pcoip-agent
		pl_dir=$ag_dir/vchan_plugins
		if [ -d  $ag_dir -a ! -d $pl_dir  ]
		then
			mkdir $pl_dir
			if [ $? != 0 ]
			then
				echo "ERROR: unable to cteate directory: $pl_dir"
			fi
		fi
		if [ -d $pl_dir  ]
		then
			ln -s $LIB_PATH $pl_dir/$LIB_NAME
			if [ $? = 0 ]
			then
				echo "linked: $pl_dir/$LIB_NAME"
			else
				echo "ERROR: unable to cteate link: $pl_dir/$LIB_NAME"				
			fi
		fi
	done
}

unlink_plugin () {
	dir=$1
	name=$2

	path="$dir/$name"
	if [ -h $path -o -f $path ]
	then
		rm $path
		if [ $? = 0 ]
		then
			echo "removed: $path"
		else
			echo "WARNING: unable to remove: $path"
		fi
	fi
}

unlink_lib () {
	unlink_plugin $AGENT_PLUGINS_DIR $LIB_NAME
	unlink_plugin $CLIENT_PLUGINS_DIR $LIB_NAME
	unlink_plugin $CLIENT_PLUGINS_DIR_OPT $LIB_NAME
	
	dirs=$(arch_dirs)
	for dir in $dirs
	do
		unlink_plugin $dir/pcoip-client/vchan_plugins $LIB_NAME
		unlink_plugin dir/pcoip-agent/vchan_plugins $LIB_NAME
	done
}

get_arch () {
	if [ "x$(uname -m | grep 'x86_64')" != "x" ]
	then
		ARCH="x86_64"
		return
	fi
	if [ "x$(uname -m | grep 'i686')" != "x" ]
	then
		ARCH="i386"
		return
	fi
	if [ "x$(uname -m | grep 'arm')" != "x" ]
	then
		ARCH="arm"
		return
	fi
}

get_arch
if [ "x$ARCH" = "xunknown" ]
then
	echo "WARNING: unable to detect machine type"
fi

case "$1" in
"-i")
	unlink_lib
	link_lib
	;;
"-u")
	unlink_lib
	;;
"-h")
	usage
	;;
*)
	usage
	;;
esac
